//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
namespace Testing
{
	interface ICommunicate
	{
		void Speak(string s);
		void Listen(string s);
		void Read(string s);
		void Write(string s);
	}
	interface ITravel
	{
		void Walk();
		void Car();
		void Train();
		void Plane();
	}
	class Activities: ICommunicate, ITravel
	{
		// ICommunicate
		public void Speak(string s)
		{
			Console.WriteLine("Powiedziaem \"{0}\".", s);
		}
		public void Listen(string s)
		{
			Console.WriteLine("Syszaem, e powiedziae \"{0}\".", s);
		}
		public void Read(string s)
		{
			Console.WriteLine("Przeczytaem \"{0}\".", s);
		}
		public void Write(string s)
		{
			Console.WriteLine("Napisaem \"{0}\".", s);
		}
		// ITravel
		public void Walk()
		{
			Console.WriteLine("Id sobi.");
		}
		public void Car()
		{
			Console.WriteLine("Jad samochodem.");
		}
		public void Train()
		{
			Console.WriteLine("Jad pocigiem.");
		}
		public void Plane()
		{
			Console.WriteLine("Lec samolotem.");
		}
	}
	class InterfaceMain
	{
		static void Main(string[] args)
		{
			Activities a = new Activities();
			try
			{
				IComparable ic = (IComparable)a;
			}
			catch(Exception e)
			{
				Console.WriteLine(e);
			}
			if(a is ICommunicate)
			{
				ICommunicate ac = (ICommunicate)a;
				ac.Speak("Powiedziaem, e");
				ac.Listen("Mwi do ciebie");
				ac.Read("Za gl ja.");
				ac.Write("Co ja robiem w czasie wakacji.");
			}
			if(a is ITravel)
			{
				ITravel at = (ITravel)a;
				at.Walk();
				at.Car();
				at.Train();
				at.Plane();
			}
			Console.WriteLine("--------------------------");
			ICommunicate c = a as ICommunicate;
			if(c != null)
			{
				c.Speak("Powiedziaem, e");
				c.Listen("Mwi do ciebie");
				c.Read("Za gl ja.");
				c.Write("Co ja robiem w czasie wakacji.");
			}
			ITravel t = a as ITravel;
			if(t != null)
			{
				t.Walk();
				t.Car();
				t.Train();
				t.Plane();
			}
		}
	}
}
